package tag.extract;

import parser.Feature;
import parser.SwigraTag;
import trees.TAGTreeNode;

public class PrzyzloFromVerb extends AltTreeBuilder {

	@Override
	protected TAGTreeNode buildFormaczas(TAGTreeNode tree) {
		TAGTreeNode root = tree.nodeCopy();
		TAGTreeNode bedzie = new TAGTreeNode();
		bedzie.subst = true;
		bedzie.id = 101;
		bedzie.tag = SwigraTag.BEDZIE;
		for (int i = 0; i < TAGTreeNode.grammarFeatures.length; ++i) {
			Feature f = TAGTreeNode.grammarFeatures[i];
			if ((f == Feature.LICZBA || f == Feature.OSOBA || f == Feature.ASPEKT)
					&& root.fs.containsKey(f)) {
				bedzie.fs.put(f, root.fs.get(f));
			}
		}
		bedzie.fs.put(Feature.CZAS, "przy");
		root.children.add(bedzie);
		TAGTreeNode przyzlo = new TAGTreeNode();
		przyzlo.trunk = true;
		przyzlo.id = 102;
		przyzlo.tag = SwigraTag.PRZY_ZLO;
		for (int i = 0; i < TAGTreeNode.grammarFeatures.length; ++i) {
			Feature f = TAGTreeNode.grammarFeatures[i];
			if ((f == Feature.RODZAJ || f == Feature.LICZBA)
					&& root.fs.containsKey(f)) {
				przyzlo.fs.put(f, root.fs.get(f));
			}
		}
		root.children.add(przyzlo);
		root.headChild = przyzlo;
		TAGTreeNode verb = tree.children.get(0).nodeCopy();
		verb.fs.put(Feature.CZAS, "prze");
		verb.fs.put(Feature.OSOBA, "3");
		verb.trunk = true;
		przyzlo.children.add(verb);
		przyzlo.headChild = verb;
		return root;
	}

}
