package tag.extract;

import parser.Feature;
import parser.SwigraTag;
import trees.TAGTreeNode;

public class VerbFromPrzyzlo extends AltTreeBuilder {

	@Override
	protected TAGTreeNode buildFormaczas(TAGTreeNode tree) {
		TAGTreeNode root = tree.nodeCopy();
		TAGTreeNode verb = tree.headChild.headChild.nodeCopy();
		verb.id = 101;
		verb.tag = SwigraTag.LEAF;
		for (int i = 0; i < TAGTreeNode.grammarFeatures.length; ++i) {
			Feature f = TAGTreeNode.grammarFeatures[i];
			if (verb.fs.containsKey(f) && root.fs.containsKey(f)) {
				verb.fs.put(f, root.fs.get(f));
			}
		}
		root.children.add(verb);
		root.headChild = verb;
		verb.trunk = true;
		return root;
	}

}
