/**
 * 
 */
package trees;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import parser.Feature;
import parser.SwigraTag;

public class SwigraTreeNode  extends TreeNode<SwigraTreeNode> {
	
	private static final long serialVersionUID = 4898654688950444848L;
	public LinkedList<Integer> childrenIds = new LinkedList<Integer>();
	
	public List<Integer> headChildren = new ArrayList<Integer>();
	public boolean isHead = false;
	public boolean error = false;
	public boolean marked = false;
	//public List<STSGSuggestion> suggestions = new LinkedList<STSGSuggestion>();

	public SwigraTreeNode() {
		this.children = new ArrayList<SwigraTreeNode>();
	}
	
	public void addChild(Integer child) {
		this.childrenIds.add(child);
	}

	public boolean isPreterminal() {
		if (this.isTerminal()) {
			return false;
		}
		for (SwigraTreeNode child : this.children) {
			if (child.isTerminal()) {
				return true;
			}
		}
		return false;
	}
	
	public SwigraTreeNode getFirstHeadChild() {
		int id = this.headChildren.get(0);
		for (SwigraTreeNode child : this.children) {
			if (child.id == id) {
				return child;
			}
		}
		System.err.println("no head children!");
		throw new NullPointerException();
	}
	
	public List<SwigraTreeNode> errorNodes() {
		List<SwigraTreeNode> ret = new LinkedList<SwigraTreeNode>();
		if(this.error) {
			ret.add(this);
		}
		for (SwigraTreeNode child : this.children) {
			ret.addAll(child.errorNodes());
		}
		return ret;
	}
	
	public List<SwigraTreeNode> markedNodes() {
		List<SwigraTreeNode> ret = new LinkedList<SwigraTreeNode>();
		if(this.marked) {
			ret.add(this);
		}
		for (SwigraTreeNode child : this.children) {
			ret.addAll(child.markedNodes());
		}
		return ret;
	}
	
	public String longTag(boolean child) {
		if (this.tag != SwigraTag.LEAF) {
			String tag = this.tag.toString();
			if (child && this.isHead) {
				tag += "-H*";
			}
			if (child && this.fs.containsKey(Feature.TFW)) {
				tag += "*" + this.fs.get(Feature.TFW);
			}
			if (child && this.fs.containsKey(Feature.DEST)) {
				tag += "*" + this.fs.get(Feature.DEST);
			}
			/*if (this.fs.containsKey(Feature.KLASA)) {
				tag += "*" + this.fs.get(Feature.KLASA);
			}*/
			if (child && this.fs.containsKey(Feature.REKCJA)) {
				tag += "*" + this.fs.get(Feature.REKCJA);
			}	
			if (child && this.fs.containsKey(Feature.JAKO_FL)) {
				tag += "*" + this.fs.get(Feature.JAKO_FL);
			}
			if (this.fs.containsKey(Feature.PRZYPADEK)) {
				tag += "*" + this.fs.get(Feature.PRZYPADEK);
			}
			if (this.fs.containsKey(Feature.LICZBA)) {
				tag += "*" + this.fs.get(Feature.LICZBA);
			}
			if (this.tag != SwigraTag.ZDANIE && this.fs.containsKey(Feature.RODZAJ)) {
				tag += "*" + this.fs.get(Feature.RODZAJ);
			}
			if (this.fs.containsKey(Feature.PRZYIMEK)) {
				tag += "*" + this.fs.get(Feature.PRZYIMEK);
			}
			if (this.tag == SwigraTag.FZD) {
				tag += "*" + this.fs.get(Feature.TFZ);
			}
			if (this.tag == SwigraTag.SPOJNIK) {
				tag += "*" + this.fs.get(Feature.OZN);
			}
			return tag;
		} else {
			return this.orth + "*" + this.pos;
		}
	}
	
	public String fullTag() {
		if (this.tag != SwigraTag.LEAF) {
			String t = this.tag.toString();
			for (Feature f : Feature.values()) {
				if (this.fs.containsKey(f)) {
					t += "*" + this.fs.get(f);
				}
			}
			return t;
		} else {
			return this.orth + "*" + this.pos;
		}
	}
	
	public int size() {
		int s = (this.tag == SwigraTag.LEAF ? 0 : 1);
		for (SwigraTreeNode child : this.children) {
			s += child.size();
		}
		return s;
	}
	
	public void collectTags(Map<SwigraTag, Integer> tags) {
		if (this.tag != SwigraTag.LEAF) {
			if (!tags.containsKey(this.tag)) {
				tags.put(this.tag, 0);
			}
			int c = tags.get(this.tag) + 1;
			tags.put(this.tag, c);
		}
		for (SwigraTreeNode child : this.children) {
			child.collectTags(tags);
		}
	}
	
	public void collectFullTags(Map<String, Integer> tags) {
		if (this.tag != SwigraTag.LEAF) {
			String t = this.fullTag();
			if (!tags.containsKey(t)) {
				tags.put(t, 0);
			}
			int c = tags.get(t) + 1;
			tags.put(t, c);
		}
		for (SwigraTreeNode child : this.children) {
			child.collectFullTags(tags);
		}
	}

	@Override
	public int compareTo(SwigraTreeNode o) {
		throw new UnsupportedOperationException();
	}

	public boolean singleHeads() {
		if (this.headChildren.size() > 1) {
			return false;
		}
		for (SwigraTreeNode child : this.children) {
			if (!child.singleHeads()) {
				return false;
			}
		}
		return true;
	}
	
	public void clearMarks() {
		this.marked = false;
		for (SwigraTreeNode child : this.children) {
			child.clearMarks();
		}
	}

}
