package trees;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import parser.Feature;
import parser.SwigraTag;

public abstract class TreeNode<T extends TreeNode<T>> implements Comparable<T>,
		Serializable {

	private static final long serialVersionUID = 9134377887578238367L;
	public SwigraTag tag = SwigraTag.LEAF;
	public Map<Feature, String> fs = new TreeMap<Feature, String>();
	public List<T> children;
	public String orth = "";
	public String base = "";
	public String pos = "";
	public String rule = "";
	public int id = 0;
	public boolean fromDep = false;

	public boolean isTerminal() {
		return this.tag == SwigraTag.LEAF;
	}

	public synchronized List<String> orths() {
		List<String> orths = new LinkedList<String>();
		for (T child : this.children) {
			orths.addAll(child.orths());
		}
		if (this.isTerminal()) {
			orths.add(this.orth);
		}
		return orths;
	}
	
	public synchronized List<String> bases() {
		List<String> bases = new LinkedList<String>();
		for (T child : this.children) {
			bases.addAll(child.orths());
		}
		if (this.isTerminal()) {
			bases.add(this.orth);
		}
		return bases;
	}

	public synchronized String sentence() {
		if (this.isTerminal()) {
			return (this.pos.contentEquals("interp") ? "" : " ") + this.orth;
		} else {
			String ret = "";
			for (T child : this.children) {
				ret += child.sentence();
			}
			return ret;
		}
	}

	public synchronized List<String> POSs() {
		List<String> words = new LinkedList<String>();
		for (T child : this.children) {
			words.addAll(child.POSs());
		}
		if (this.isTerminal()) {
			words.add(this.pos);
		}
		return words;
	}
	
	public String shape() {
		String s = this.tag + "(";
		for (T child : this.children) {
			s += child.shape();
		}
		return s + ")";
	}
	
	public int size() {
		int s = 1;
		for (T child : this.children) {
			s += child.size();
		}
		return s;
	}
	
	public boolean contains(SwigraTag tag) {
		if (this.tag == tag) {
			return true;
		}
		for (T child : this.children) {
			if (child.contains(tag)) {
				return true;
			}
		}
		return false;
	}
	
	public List<T> findAll(SwigraTag tag) {
		List<T> c = new LinkedList<T>();
		this.collect(tag, c);
		return c;
	}
	
	public T findFirst(SwigraTag tag) {
		List<T> c = this.findAll(tag);
		if (c.isEmpty()) {
			return null;
		} else {
			return c.get(0);
		}
	}
	
	@SuppressWarnings("unchecked")
	private void collect(SwigraTag tag, List<T> c) {
		if (this.tag == tag) {
			c.add((T) this);
		}
		for (T child : this.children) {
			child.collect(tag, c);
		}
	}

}
