package utility;

import java.util.HashMap;
import java.util.Map.Entry;
import java.util.Set;

public class Counter<T> {
	
	private HashMap<T, Integer> map = new HashMap<T, Integer>();
	
	public void increase(T key) {
		Integer c = (this.map.containsKey(key) ? this.map.get(key) : 0) + 1;
		this.map.put(key, c);
	}
	
	public void increaseBy(T key, int by) {
		Integer c = (this.map.containsKey(key) ? this.map.get(key) : 0) + by;
		this.map.put(key, c);
	}
	
	public Integer get(T key) {
		return (this.map.containsKey(key) ? this.map.get(key) : 0);
	}
	
	public Integer increaseAndGet(T key) {
		this.increase(key);
		return this.map.get(key);
	}
	
	public Integer getAndIncrease(T key) {
		this.increase(key);
		return this.map.get(key) - 1;
	}
	
	public boolean containsKey(T key) {
		return this.map.containsKey(key);
	}
	
	public Set<T> keySet() {
		return this.map.keySet();
	}
	
	public Set<Entry<T, Integer>> entrySet() {
		return this.map.entrySet();
	}
	
}
