package utility;

import java.util.HashMap;

public class FallbackMap<T1, T2> extends HashMap<T1, T2> {

	private static final long serialVersionUID = 1L;
	private T2 fallback;
	
	public FallbackMap(T2 fallback) {
		super();
		this.fallback = fallback;
	}

	@Override
	public T2 get(Object key) {
		T2 value = super.get(key);
		if (value != null) {
			return value;
		} else {
			return this.fallback;
		}
	}
	
	
}
