package utility;

import java.io.Serializable;

public class Pair<T1, T2> implements Comparable<Pair<T1, T2>>, Serializable {

	private static final long serialVersionUID = -1820288395053647626L;
	private T1 e1;
	private T2 e2;

	public Pair() {
		this.e1 = null;
		this.e2 = null;
	}

	public Pair(T1 e1, T2 e2) {
		this.e1 = e1;
		this.e2 = e2;
	}

	public T1 first() {
		return this.e1;
	}

	public T2 second() {
		return this.e2;
	}

	public void setFirst(T1 first) {
		this.e1 = first;
	}

	public void setSecond(T2 second) {
		this.e2 = second;
	}

	public Pair<T2, T1> reverse() {
		return new Pair<T2, T1>(this.e2, this.e1);
	}

	@SuppressWarnings("unchecked")
	@Override
	public int compareTo(Pair<T1, T2> other) {
		if (((Comparable<T1>) this.e1).compareTo(other.e1) != 0) {
			return ((Comparable<T1>) this.e1).compareTo(other.e1);
		} else {
			//System.out.println("--- Pair");
			//System.out.println(this.e2.toString() + " to " + other.e2.toString());
			return ((Comparable<T2>) this.e2).compareTo(other.e2);
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (obj.getClass() != this.getClass()) {
			return false;
		}
		if ((this.e1 == null) != (this.e2 == null)) {
			return false;
		}
		if (this.e1 == null && this.e2 == null) {
			return false;
		}
		@SuppressWarnings("unchecked")
		Pair<T1, T2> other = (Pair<T1, T2>) obj;
		return this.e1.equals(other.e1) && this.e2.equals(other.e2);
	}

	@Override
	public int hashCode() {
		return (this.e1 != null ? this.e1.hashCode() : 1)
				+ (this.e2 != null ? this.e2.hashCode() : 1);
	}

	@Override
	public String toString() {
		return "<" + (this.e1 != null ? this.e1.toString() : "null") + ", "
				+ (this.e2 != null ? this.e2.toString() : "null") + ">";
	}

}
