package utility;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Utility {

	@SuppressWarnings("rawtypes")
	public static Pair[] punctuation = {
			new Pair<String, String>(",", "comma"),
			new Pair<String, String>(".", "fullstop"),
			new Pair<String, String>("(", "lpar"),
			new Pair<String, String>(")", "rpar"),
			new Pair<String, String>("?", "qmark"),
			new Pair<String, String>("!", "excl"),
			new Pair<String, String>(";", "semicol"),
			new Pair<String, String>(":", "col"),
			new Pair<String, String>("\"", "quot"),
			new Pair<String, String>("-", "hyph"),
			new Pair<String, String>("–", "longhyph"),
			new Pair<String, String>("—", "longlonghyph"),
			new Pair<String, String>("…", "dots") };

	public static List<String> findFiles(String path) {

		File root = new File(path);
		File[] list = root.listFiles();
		List<String> fileList = new ArrayList<String>();
		for (File f : list) {
			if (f.isDirectory()) {
				fileList.addAll(findFiles(f.getAbsolutePath()));
			} else {
				fileList.add(f.getAbsolutePath());
			}
		}
		return fileList;
	}

	public Set<List<Integer>> subsets(int i) {
		Set<List<Integer>> s;
		if (i == 0) {
			s = new HashSet<List<Integer>>();
			s.add(new LinkedList<Integer>());
		} else {
			s = this.subsets(i - 1);
			HashSet<List<Integer>> s2 = new HashSet<List<Integer>>();
			for (List<Integer> l : s) {
				List<Integer> l2 = new LinkedList<Integer>(l);
				l2.add(i);
				s2.add(l2);
			}
			s.addAll(s2);
		}
		return s;
	}

	public static String toAscii(String s) {
		return s.replace('ą', 'a').replace('ć', 'c').replace('ę', 'e')
				.replace('ł', 'l').replace('ń', 'n').replace('ó', 'o')
				.replace('ś', 's').replace('ź', 'z').replace('ż', 'z')
				.replace('Ą', 'A').replace('Ć', 'C').replace('Ę', 'E')
				.replace('Ł', 'L').replace('Ń', 'N').replace('Ó', 'O')
				.replace('Ś', 'S').replace('Ź', 'Z').replace('Ż', 'Z');
	}

	public static String translatePosTag(String tag) {
		if (tag.contentEquals("sg")) {
			return "poj";
		}
		if (tag.contentEquals("pl")) {
			return "mno";
		}
		if (tag.contentEquals("nom")) {
			return "mian";
		}
		if (tag.contentEquals("gen")) {
			return "dop";
		}
		if (tag.contentEquals("dat")) {
			return "cel";
		}
		if (tag.contentEquals("acc")) {
			return "bier";
		}
		if (tag.contentEquals("loc")) {
			return "miej";
		}
		if (tag.contentEquals("inst")) {
			return "narz";
		}
		if (tag.contentEquals("voc")) {
			return "wol";
		}
		if (tag.contentEquals("m1")) {
			return "mos";
		}
		if (tag.contentEquals("m2")) {
			return "mzw";
		}
		if (tag.contentEquals("m3")) {
			return "mnz";
		}
		if (tag.contentEquals("f")) {
			return "zen";
		}
		if (tag.contentEquals("n")) {
			return "nij";
		}
		if (tag.contentEquals("pri")) {
			return "1";
		}
		if (tag.contentEquals("sec")) {
			return "2";
		}
		if (tag.contentEquals("ter")) {
			return "3";
		}
		if (tag.contentEquals("aff")) {
			return "nie";
		}
		if (tag.contentEquals("neg")) {
			return "tak";
		}
		return tag;
	}
	
	public static boolean isInterp(String s) {
		for (int i = 0; i < Utility.punctuation.length; ++i) {
			if (s.equals((String) Utility.punctuation[i].first())) {
				return true;
			}
		}
		return false;
	}

	public static String join(Collection<?> c, String delimiter) {
		StringBuilder ret = new StringBuilder();
		for (Iterator<?> it = c.iterator(); it.hasNext();) {
			ret.append(it.next());
			if (it.hasNext()) {
				ret.append(delimiter);
			}
		}
		return ret.toString();
	}
	public static String join(Object[] c, String delimiter) {
		StringBuilder ret = new StringBuilder();
		for (int i = 0; i < c.length; ++ i) {
			ret.append(c[i]);
			if (i < c.length - 1) {
				ret.append(delimiter);
			}
		}
		return ret.toString();
	}

}
